function [expr,cellid]=makeexprmat(seqC,ref,match,Nmatch,Lnew,rol,rolidx)
%assign rolonies to cells to make expression matrix
%   seqC: sequence of rolonies in ATCG, char array.
%   ref: sequence of reference in ATCG,cell array
%   match: # of matching bases required for matching seqC to ref
%   Lnew: cell positions and ids generated by findnuclei.
%   rol: rolony positions (Without nricp) generated by seqfindroloniesij
%   rolidx: the indices of matching rolonies genreated by nricpbasecall

%convert sequences to gene tags
genes=zeros(length(seqC),1);
for i=1:length(ref)
    ref1=repmat(ref{i},length(seqC),1);
    I=sum(ref1(:,1:size(seqC,2))==seqC,2);
    genes(I>=match&(I+sum(seqC=='N',2))>=(Nmatch+match))=i;
end
figure;scatter(rol{1}(genes>0,2),rol{1}(genes>0,1),3,genes(genes>0),'filled');

%assign rolonies to cells.
cellidx=zeros(length(genes),1);

for i=1:length(genes)
    cellidx(i)=Lnew(rol{end}(rolidx(i,end),1),rol{end}(rolidx(i,end),2));
end
%remove rolonies with no cells and cells with no rolonies
i=(cellidx>0)&(genes>0);
cellidx(~i)=[];
genes(~i)=[];

cellid=unique(cellidx);%cell to Lnew lookup
[~,c]=ismember(cellidx,unique(cellidx));
expr=zeros(length(cellid),length(ref));
lidx=sub2ind(size(expr),c,genes);
for i=1:length(lidx)
    expr(lidx(i))=expr(lidx(i))+1;
end

save('expr.mat','expr','cellid','ref');